package gui;

import java.awt.EventQueue;

import javax.swing.JFrame;

import java.awt.BorderLayout;

import javax.swing.JButton;
import javax.swing.JPanel;

import java.awt.Color;

import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JLabel;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.Font;
import java.awt.SystemColor;

import javax.swing.JSplitPane;

import java.awt.Dimension;

import javax.swing.JScrollPane;
import javax.swing.ImageIcon;

import music.Song;
import net.miginfocom.swing.MigLayout;

import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.ButtonGroup;

import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;
import java.awt.Rectangle;
import javax.swing.JTextArea;

public class MainAppWindow {

	private JFrame frmLikeARolling;
	private JPanel northPanel;
	private JPanel westPanel;
	private JPanel southPanel;
	private JPanel eastPanel;
	private JPanel centerPanel;
	private JMenuBar menuBar;
	private JMenu mnFile;
	private JMenu mnEdit;
	private JMenu mnHelp;
	private JMenuItem mntmNew;
	private JMenuItem mntmOpen;
	private JMenuItem mntmSave;
	private JMenuItem mntmExit;
	private JButton btnStart;
	private JLabel lblLegendarySongs;
	private JSplitPane splitPane;
	private JScrollPane leftScrollPane;
	private JScrollPane rightScrollPane;
	private JLabel lblPhoto;
	private JLabel lblSongs;
	private JComboBox songsComboBox;
	private JLabel lblYear;
	private JLabel lblYearValue;
	private JButton btnSave;
	private JRadioButton rdbtnBasic;
	private JRadioButton rdbtnPhoto;
	private JRadioButton rdbtnAll;
	private JLabel lblDetails;
	private final ButtonGroup buttonGroup = new ButtonGroup();
	
	NewDialog newDialog = null;
	Song song = null;
	private JTextArea lyricsTextArea;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					MainAppWindow window = new MainAppWindow();
					window.frmLikeARolling.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public MainAppWindow() {
		initialize();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frmLikeARolling = new JFrame();
		frmLikeARolling.setTitle("Like a Rolling Stone");
		frmLikeARolling.setBounds(100, 100, 450, 300);
		frmLikeARolling.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frmLikeARolling.getContentPane().setLayout(new BorderLayout(0, 0));
		frmLikeARolling.getContentPane().add(getNorthPanel(), BorderLayout.NORTH);
		frmLikeARolling.getContentPane().add(getWestPanel(), BorderLayout.WEST);
		frmLikeARolling.getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
		frmLikeARolling.getContentPane().add(getEastPanel(), BorderLayout.EAST);
		frmLikeARolling.getContentPane().add(getCenterPanel(), BorderLayout.CENTER);
		frmLikeARolling.setJMenuBar(getMenuBar());
	}
	private JPanel getNorthPanel() {
		if (northPanel == null) {
			northPanel = new JPanel();
			northPanel.add(getBtnStart());
			northPanel.add(getLblLegendarySongs());
		}
		return northPanel;
	}
	private JPanel getWestPanel() {
		if (westPanel == null) {
			westPanel = new JPanel();
			westPanel.setLayout(new MigLayout("", "[grow][]", "[][]"));
			westPanel.add(getLblSongs(), "cell 0 0");
			westPanel.add(getSongsComboBox(), "cell 0 1 2 1,growx");
			westPanel.setVisible(false);
		}
		return westPanel;
	}
	private JPanel getSouthPanel() {
		if (southPanel == null) {
			southPanel = new JPanel();
			southPanel.setLayout(new MigLayout("", "[grow][][][][grow]", "[][]"));
			southPanel.add(getLblDetails(), "cell 1 0 3 1,alignx center");
			southPanel.add(getRdbtnBasic(), "cell 1 1");
			southPanel.add(getRdbtnPhoto(), "cell 2 1");
			southPanel.add(getRdbtnAll(), "cell 3 1");
			southPanel.setVisible(false);
		}
		return southPanel;
	}
	private JPanel getEastPanel() {
		if (eastPanel == null) {
			eastPanel = new JPanel();
			eastPanel.setLayout(new MigLayout("", "[22px]", "[14px][][grow][]"));
			eastPanel.add(getLblYear(), "cell 0 0,alignx left,aligny top");
			eastPanel.add(getLblYearValue(), "cell 0 1");
			eastPanel.add(getBtnSave(), "cell 0 3");
			eastPanel.setVisible(false);
		}
		return eastPanel;
	}
	private JPanel getCenterPanel() {
		if (centerPanel == null) {
			centerPanel = new JPanel();
			centerPanel.setVisible(false);
			centerPanel.setLayout(new MigLayout("", "[400px]", "[179px]"));
			centerPanel.add(getSplitPane(), "cell 0 0,alignx left,aligny top");
		}
		return centerPanel;
	}
	private JMenuBar getMenuBar() {
		if (menuBar == null) {
			menuBar = new JMenuBar();
			menuBar.add(getMnFile());
			menuBar.add(getMnEdit());
			menuBar.add(getMnHelp());
		}
		return menuBar;
	}
	private JMenu getMnFile() {
		if (mnFile == null) {
			mnFile = new JMenu("File");
			mnFile.add(getMntmNew());
			mnFile.add(getMntmOpen());
			mnFile.add(getMntmSave());
			mnFile.addSeparator();
			mnFile.add(getMntmExit());
		}
		return mnFile;
	}
	private JMenu getMnEdit() {
		if (mnEdit == null) {
			mnEdit = new JMenu("Edit");
		}
		return mnEdit;
	}
	private JMenu getMnHelp() {
		if (mnHelp == null) {
			mnHelp = new JMenu("Help");
		}
		return mnHelp;
	}
	private JMenuItem getMntmNew() {
		if (mntmNew == null) {
			mntmNew = new JMenuItem("New");
			mntmNew.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					newDialog = new NewDialog(frmLikeARolling, true);
					song = newDialog.showDialog();
					songsComboBox.addItem(song.getTitle());
					lblPhoto.setIcon(song.getAuthor().getImage());
					lyricsTextArea.setText(song.getLyrics());
					lblYearValue.setText(String.valueOf(song.getYear()));
				}
			});
		}
		return mntmNew;
	}
	private JMenuItem getMntmOpen() {
		if (mntmOpen == null) {
			mntmOpen = new JMenuItem("Open...");
		}
		return mntmOpen;
	}
	private JMenuItem getMntmSave() {
		if (mntmSave == null) {
			mntmSave = new JMenuItem("Save...");
		}
		return mntmSave;
	}
	private JMenuItem getMntmExit() {
		if (mntmExit == null) {
			mntmExit = new JMenuItem("Exit");
		}
		return mntmExit;
	}
	private JButton getBtnStart() {
		if (btnStart == null) {
			btnStart = new JButton("Start");
			btnStart.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					lblLegendarySongs.setVisible(true);
					btnStart.setVisible(false);
					southPanel.setVisible(true);
					westPanel.setVisible(true);
					eastPanel.setVisible(true);
					centerPanel.setVisible(true);
				}
			});
		}
		return btnStart;
	}
	private JLabel getLblLegendarySongs() {
		if (lblLegendarySongs == null) {
			lblLegendarySongs = new JLabel("Legendary songs");
			lblLegendarySongs.setForeground(SystemColor.activeCaption);
			lblLegendarySongs.setFont(new Font("Tahoma", Font.BOLD, 13));
			lblLegendarySongs.setVisible(false);
		}
		return lblLegendarySongs;
	}
	private JSplitPane getSplitPane() {
		if (splitPane == null) {
			splitPane = new JSplitPane();
			splitPane.setPreferredSize(new Dimension(400, 179));
			splitPane.setDividerSize(8);
			splitPane.setDividerLocation(50);
			splitPane.setOneTouchExpandable(true);
			splitPane.setLeftComponent(getLeftScrollPane());
			splitPane.setRightComponent(getRightScrollPane());
		}
		return splitPane;
	}
	private JScrollPane getLeftScrollPane() {
		if (leftScrollPane == null) {
			leftScrollPane = new JScrollPane();
			leftScrollPane.setViewportView(getLblPhoto());
		}
		return leftScrollPane;
	}
	private JScrollPane getRightScrollPane() {
		if (rightScrollPane == null) {
			rightScrollPane = new JScrollPane();
			rightScrollPane.setViewportView(getLyricsTextArea());
		}
		return rightScrollPane;
	}
	private JLabel getLblPhoto() {
		if (lblPhoto == null) {
			lblPhoto = new JLabel("");
			lblPhoto.setIcon(new ImageIcon("C:\\Documents and Settings\\student1.B009\\My Documents\\Like a Rolling Stone, 23.12.2015, 14-16, E\\resources\\Bob Dylan.jpg"));
		}
		return lblPhoto;
	}
	private JLabel getLblSongs() {
		if (lblSongs == null) {
			lblSongs = new JLabel("Songs");
		}
		return lblSongs;
	}
	private JComboBox getSongsComboBox() {
		if (songsComboBox == null) {
			songsComboBox = new JComboBox();
		}
		return songsComboBox;
	}
	private JLabel getLblYear() {
		if (lblYear == null) {
			lblYear = new JLabel("Year");
		}
		return lblYear;
	}
	private JLabel getLblYearValue() {
		if (lblYearValue == null) {
			lblYearValue = new JLabel("");
		}
		return lblYearValue;
	}
	private JButton getBtnSave() {
		if (btnSave == null) {
			btnSave = new JButton("Save");
		}
		return btnSave;
	}
	private JRadioButton getRdbtnBasic() {
		if (rdbtnBasic == null) {
			rdbtnBasic = new JRadioButton("Basic");
			rdbtnBasic.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent arg0) {
					getWestPanel().setVisible(true);
//					getEastPanel().setVisible(false);
					getLblYear().setVisible(false);
					getLblYearValue().setVisible(false);
					getBtnSave().setVisible(false);
					getCenterPanel().setVisible(false);
				}
			});
			buttonGroup.add(rdbtnBasic);
		}
		return rdbtnBasic;
	}
	private JRadioButton getRdbtnPhoto() {
		if (rdbtnPhoto == null) {
			rdbtnPhoto = new JRadioButton("Photo");
			rdbtnPhoto.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getWestPanel().setVisible(true);
//					getEastPanel().setVisible(false);
					getLblYear().setVisible(false);
					getLblYearValue().setVisible(false);
					getBtnSave().setVisible(false);
					getCenterPanel().setVisible(true);
				}
			});
			buttonGroup.add(rdbtnPhoto);
			rdbtnPhoto.setSelected(true);
		}
		return rdbtnPhoto;
	}
	private JRadioButton getRdbtnAll() {
		if (rdbtnAll == null) {
			rdbtnAll = new JRadioButton("All");
			rdbtnAll.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getWestPanel().setVisible(true);
//					getEastPanel().setVisible(false);
					getLblYear().setVisible(true);
					getLblYearValue().setVisible(true);
					getBtnSave().setVisible(true);
					getCenterPanel().setVisible(true);
				}
			});
			buttonGroup.add(rdbtnAll);
		}
		return rdbtnAll;
	}
	private JLabel getLblDetails() {
		if (lblDetails == null) {
			lblDetails = new JLabel("Details");
		}
		return lblDetails;
	}
	private JTextArea getLyricsTextArea() {
		if (lyricsTextArea == null) {
			lyricsTextArea = new JTextArea();
		}
		return lyricsTextArea;
	}
}
